/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_FRIENDS_INTERFACE_H
#define _SCE_FRIENDS_INTERFACE_H

#include "np_toolkit_defines.h"

namespace sce {
	namespace Toolkit{
		namespace NP{

	/// @brief
	/// The namespace containing friends list functionality.
	///
	/// The namespace containing friends list functionality.
	namespace Friends{

	/// @brief
	/// The interface for accessing the friends list.
	///
	/// This interface allows the game to retrieve the current user's list of friends from the PlayStationNetwork.
	class Interface
	{
	public:

		/// @brief 
		/// Retrieves the user's friends list.
		///
		/// Retrieves the user's friends list. The results also contain presence information about each friend.
		/// 
		/// If the process is asynchronous the application is notified by a <c>friendsGotFriendsList</c> or <c>friendsNoFriends</c>
		/// Event. The application can then verify whether there was an error during 
		/// the process or whether the process was successful by using the <c>hasError()</c> or <c>hasResult()</c> method of the <c>Future</c> object.
		/// If an error has occurred, the application can get the error code using the <c>getError()</c> method.
		/// On successful completion of the operation, the application can retrieve the result using the 
		/// <c>get()</c> method of the <c>Future</c> object.  
		///
		/// @param friendslist	A pointer to the vector that contains all of the user's friends.
		/// @param async		A flag that indicates whether the function is non-blocking or blocking. 
		///						Defaults to true so the function is non-blocking by default.	
		///  
		/// @retval SCE_TOOLKIT_NP_SUCCESS								The operation was successful.							 
		/// @retval SCE_TOOLKIT_NP_NOT_INITIALISED						The %NP %Toolkit library is not initialized.
		static int getFriendslist(sce::Toolkit::NP::Utilities::Future<FriendsList > *friendslist, bool async = true);

		/// @brief 
		/// Adds to the user's friends list.
		///
		/// Adds to the user's friends list. This will bring up the system GUI, where the user can input a message
		///	that will be sent with the friend invitation.
		/// 
		/// @param user			The user to add as a friend.
		/// @param async		A flag that indicates whether the function is non-blocking or blocking. 
		///						Defaults to true so the function is non-blocking by default.	
		///  
		/// @retval SCE_TOOLKIT_NP_SUCCESS								The operation was successful.							 
		/// @retval SCE_TOOLKIT_NP_NOT_INITIALISED						The %NP %Toolkit library is not initialized.
		static int addFriend(SceNpId *user, bool async = true);
	};

			}//end friends
		}// end NP
	}// end Toolkit
}//end Sce
#endif
